function [out,pvals,pairs]=ParCorrallpairs(x,type)
% calculates the sample partial correlations of all pairs, in data x. Rows
% of x are obs and columns are variables. type is a string with values
% 'Pearson' or 'Spearman'. Default is 'Pearson'. pvals are the p-values of 
% the hypothesis: Partial correlation of this pair=0 
if nargin==1
   type='Pearson';
end
[T,N]=size(x);
d=N*(N-1)/2;
if nargout==2
    pvals=[];
end

out=-99*ones(d,1);
counter=1;
pairs=zeros(d,2);
pvals=2*ones(d,1);
for i=1:N
    for j=i+1:N
        conditionset=pcsubmatrix(x,i,j);
        pairs(counter,1)=i; pairs(counter,2)=j;
        [parcorrs,prob]=partialcorr([x(:,i),x(:,j)],conditionset,'type',type);
        pvals(counter)=vecl(prob);
        out(counter)=vecl(parcorrs);
        counter=counter+1;
    end
end
out=ivecl(out);